/* --COPYRIGHT--,BSD
 * Copyright (c) 2015, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * --/COPYRIGHT--*/
//****************************************************************************
//
// main.c - MSP-EXP432P401R + Educational Boosterpack MkII - Light Sensor
//
//          Displays lux value measured by the OPT3001 Digital Ambient
//          Light Sensor on the colored LCD. The MSP432 communicates
//          with the sensor through I2C.
//
//          The ambient light measurement is also used to automatically
//          adjust the LCD backlight.
//
//      *** Make sure J5 jumper on the BOOSTXL-EDUMKII is connected ***
//          to 3.LCD BACKLT
//
//****************************************************************************

#include <ti/devices/msp432p4xx/inc/msp.h>
#include <ti/devices/msp432p4xx/driverlib/driverlib.h>
#include <ti/grlib/grlib.h>
#include "HAL_I2C.h"
#include <stdio.h>
#define CPU_F ((double)25000000)
#define delay_us(x) __delay_cycles((long)(CPU_F*(double)x/1000000.0))
#define delay_ms(x) __delay_cycles((long)(CPU_F*(double)x/1000.0))

unsigned char key_flag=0;
int count, num;

/* Slave Address for I2C Slave */
#define SLAVE_ADDRESS  0x68 //slave address for All Call
/*
 * Main function
 */
int main(void)
 {
    /* Halting WDT and disabling master interrupts */
    MAP_WDT_A_holdTimer();
    MAP_Interrupt_disableMaster();

    /* Initializes Clock System*/
    //MAP_CS_setDCOCenteredFrequency(CS_DCO_FREQUENCY_48);
    MAP_CS_initClockSignal(CS_MCLK, CS_DCOCLK_SELECT, CS_CLOCK_DIVIDER_1);
    MAP_CS_initClockSignal(CS_HSMCLK, CS_DCOCLK_SELECT, CS_CLOCK_DIVIDER_1);
    MAP_CS_initClockSignal(CS_SMCLK, CS_DCOCLK_SELECT, CS_CLOCK_DIVIDER_1);
    MAP_CS_initClockSignal(CS_ACLK, CS_REFOCLK_SELECT, CS_CLOCK_DIVIDER_1);

    /* Configuring P1.1 as an input and enabling interrupts */
    MAP_GPIO_setAsInputPinWithPullUpResistor(GPIO_PORT_P1, GPIO_PIN1);
    MAP_GPIO_clearInterruptFlag(GPIO_PORT_P1, GPIO_PIN1);
    MAP_GPIO_enableInterrupt(GPIO_PORT_P1, GPIO_PIN1);
    MAP_Interrupt_enableInterrupt(INT_PORT1);

    /* Enabling SRAM Bank Retention */
    MAP_SysCtl_enableSRAMBankRetention(SYSCTL_SRAM_BANK1);

    /* Enabling MASTER interrupts */
    MAP_Interrupt_enableMaster();

    GPIO_setAsOutputPin(GPIO_PORT_P1, GPIO_PIN0);

    /* Initialize I2C communication */
    Init_I2C_GPIO();
    I2C_init();
    MAP_I2C_setSlaveAddress(EUSCI_B1_BASE, SLAVE_ADDRESS);

    /*MODE1=0x10*/
    MAP_I2C_masterSendMultiByteStart(EUSCI_B1_BASE, 0x00);  //send register address
    MAP_I2C_masterSendMultiByteFinish(EUSCI_B1_BASE,0x01); // send register data
    delay_ms(1);

    /*MODE2=0*/
    MAP_I2C_masterSendMultiByteStart(EUSCI_B1_BASE, 0x01);  //send register address
    MAP_I2C_masterSendMultiByteFinish(EUSCI_B1_BASE,0x00); // send register data

    /*PWM0*/
    MAP_I2C_masterSendMultiByteStart(EUSCI_B1_BASE, 0x02);  //send register address
    MAP_I2C_masterSendMultiByteFinish(EUSCI_B1_BASE,0xFF); // send register data
    /*PWM1*/
    MAP_I2C_masterSendMultiByteStart(EUSCI_B1_BASE, 0x03);  //send register address
    MAP_I2C_masterSendMultiByteFinish(EUSCI_B1_BASE,0xFF); // send register data
    /*PWM2*/
    MAP_I2C_masterSendMultiByteStart(EUSCI_B1_BASE, 0x04);  //send register address
    MAP_I2C_masterSendMultiByteFinish(EUSCI_B1_BASE,0xFF); // send register data
    /*PWM3*/
    MAP_I2C_masterSendMultiByteStart(EUSCI_B1_BASE, 0x05);  //send register address
    MAP_I2C_masterSendMultiByteFinish(EUSCI_B1_BASE,0xFF); // send register data
    /*PWM4*/
    MAP_I2C_masterSendMultiByteStart(EUSCI_B1_BASE, 0x06);  //send register address
    MAP_I2C_masterSendMultiByteFinish(EUSCI_B1_BASE,0xFF); // send register data
    /*PWM5*/
    MAP_I2C_masterSendMultiByteStart(EUSCI_B1_BASE, 0x07);  //send register address
    MAP_I2C_masterSendMultiByteFinish(EUSCI_B1_BASE,0xFF); // send register data
    /*PWM6*/
    MAP_I2C_masterSendMultiByteStart(EUSCI_B1_BASE, 0x08);  //send register address
    MAP_I2C_masterSendMultiByteFinish(EUSCI_B1_BASE,0xFF); // send register data
    /*PWM7*/
    MAP_I2C_masterSendMultiByteStart(EUSCI_B1_BASE, 0x09);  //send register address
    MAP_I2C_masterSendMultiByteFinish(EUSCI_B1_BASE,0xFF); // send register data
    /*PWM8*/
    MAP_I2C_masterSendMultiByteStart(EUSCI_B1_BASE, 0x0A);  //send register address
    MAP_I2C_masterSendMultiByteFinish(EUSCI_B1_BASE,0xFF); // send register data
    /*PWM9*/
    MAP_I2C_masterSendMultiByteStart(EUSCI_B1_BASE, 0x0B);  //send register address
    MAP_I2C_masterSendMultiByteFinish(EUSCI_B1_BASE,0xFF); // send register data
    /*PWM10*/
    MAP_I2C_masterSendMultiByteStart(EUSCI_B1_BASE, 0x0C);  //send register address
    MAP_I2C_masterSendMultiByteFinish(EUSCI_B1_BASE,0xFF); // send register data
    /*PWM11*/
    MAP_I2C_masterSendMultiByteStart(EUSCI_B1_BASE, 0x0D);  //send register address
    MAP_I2C_masterSendMultiByteFinish(EUSCI_B1_BASE,0xFF); // send register data
    /*PWM12*/
    MAP_I2C_masterSendMultiByteStart(EUSCI_B1_BASE, 0x0E);  //send register address
    MAP_I2C_masterSendMultiByteFinish(EUSCI_B1_BASE,0xFF); // send register data
    /*PWM13*/
    MAP_I2C_masterSendMultiByteStart(EUSCI_B1_BASE, 0x0F);  //send register address
    MAP_I2C_masterSendMultiByteFinish(EUSCI_B1_BASE,0xFF); // send register data
    /*PWM14*/
    MAP_I2C_masterSendMultiByteStart(EUSCI_B1_BASE, 0x10);  //send register address
    MAP_I2C_masterSendMultiByteFinish(EUSCI_B1_BASE,0xFF); // send register data
    /*PWM15*/
    MAP_I2C_masterSendMultiByteStart(EUSCI_B1_BASE, 0x11);  //send register address
    MAP_I2C_masterSendMultiByteFinish(EUSCI_B1_BASE,0xFF); // send register data

    /*GRPPWM*/
    MAP_I2C_masterSendMultiByteStart(EUSCI_B1_BASE, 0x12);  //send register address
    MAP_I2C_masterSendMultiByteFinish(EUSCI_B1_BASE,0xFF); // send register data

    /*GRPFREQ*/
    MAP_I2C_masterSendMultiByteStart(EUSCI_B1_BASE, 0x13);  //send register address
    MAP_I2C_masterSendMultiByteFinish(EUSCI_B1_BASE,0x3F); // send register data

    /*LEDOUT0*/
    MAP_I2C_masterSendMultiByteStart(EUSCI_B1_BASE, 0x14);  //send register address
    MAP_I2C_masterSendMultiByteFinish(EUSCI_B1_BASE,0xFF); // send register data

    /*LEDOUT1*/
    MAP_I2C_masterSendMultiByteStart(EUSCI_B1_BASE, 0x15);  //send register address
    MAP_I2C_masterSendMultiByteFinish(EUSCI_B1_BASE,0xFF); // send register data

    /*LEDOUT2*/
    MAP_I2C_masterSendMultiByteStart(EUSCI_B1_BASE, 0x16);  //send register address
    MAP_I2C_masterSendMultiByteFinish(EUSCI_B1_BASE,0xFF); // send register data

    /*LEDOUT3*/
    MAP_I2C_masterSendMultiByteStart(EUSCI_B1_BASE, 0x17);  //send register address
    MAP_I2C_masterSendMultiByteFinish(EUSCI_B1_BASE,0xFF); // send register data

    /*IREF=0xFF*/
    MAP_I2C_masterSendMultiByteStart(EUSCI_B1_BASE, 0x1C);  //send register address
    MAP_I2C_masterSendMultiByteFinish(EUSCI_B1_BASE,0xF8); // send register data

    while(1)
    {
        for(count=0;count<201;count++) //refresh the PWM from low to high
        {
            for(num=0x02;num<=0x11;num++) //refresh PWM0 to PWM15
            {
                MAP_I2C_masterSendMultiByteStart(EUSCI_B1_BASE, num);  //send register address
                MAP_I2C_masterSendMultiByteFinish(EUSCI_B1_BASE, count); // send register data
            }
            delay_ms(1);
        }
        for(count=200;count>=0;count--) //refresh the PWM from high to low
        {
            for(num=0x02;num<=0x11;num++) //refresh PWM0 to PWM15
            {
                MAP_I2C_masterSendMultiByteStart(EUSCI_B1_BASE, num);  //send register address
                MAP_I2C_masterSendMultiByteFinish(EUSCI_B1_BASE, count); // send register data
            }
            delay_ms(1);
        }
    }

}

void PORT1_IRQHandler(void)
{
    uint32_t status;

    status = MAP_GPIO_getEnabledInterruptStatus(GPIO_PORT_P1);
    MAP_GPIO_clearInterruptFlag(GPIO_PORT_P1, status);
    key_flag++;
    if(key_flag==18) key_flag=1;
}
